import Utilities.gui_creator as gc
import Utilities.nidaq_operations as no
import threading
import time

root = gc.create_window(title='Frequency Meter',
                        size='300x100')

channel_name = 'Dev1/ctr0'
edge_source = '/Dev1/PFI0'
task = no.create_ci_task(channel_name,edge_source)

lbl_2 = gc.create_indicator(root,
                            label_1='Frequency (Hz)')

def acquire_sample():

    while btn.cget('text') == 'Stop':
        task.start()
        time.sleep(1.0)
        count = task.read()
        task.stop()
        string_data = str(count)

        lbl_2.config(text=string_data)

    return

def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text='Stop')
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')

    t = threading.Thread(target=acquire_sample)
    t.start()

    return

btn = gc.action_button(root,label='Start',
                       action=toggle)

root.mainloop()

task.close()
